/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.util;

import jpcsp.media.codec.CodecFactory;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class FFT {
    private static Logger log = CodecFactory.log;
    int nbits;
    boolean inverse;
    int[] revtab = new int[0];
    float[] tmpBuf = new float[0];
    int mdctSize;
    int mdctBits;
    float[] tcos = new float[0];
    float[] tsin = new float[0];
    public static final double M_SQRT1_2 = 0.7071067811865476;
    private static final float sqrthalf = 0.70710677f;
    private static final float[] ff_cos_16 = new float[8];
    private static final float[] ff_cos_32 = new float[16];
    private static final float[] ff_cos_64 = new float[32];
    private static final float[] ff_cos_128 = new float[64];
    private static final float[] ff_cos_256 = new float[128];
    private static final float[] ff_cos_512 = new float[256];

    public void copy(FFT that) {
        this.nbits = that.nbits;
        this.inverse = that.inverse;
        Utilities.copy(this.revtab, that.revtab);
        Utilities.copy(this.tmpBuf, that.tmpBuf);
        this.mdctSize = that.mdctSize;
        this.mdctBits = that.mdctBits;
        Utilities.copy(this.tcos, that.tcos);
        Utilities.copy(this.tsin, that.tsin);
    }

    private static void initFfCosTabs(float[] tab, int m) {
        int i;
        double freq = Math.PI * 2 / (double)m;
        for (i = 0; i <= m / 4; ++i) {
            tab[i] = (float)Math.cos((double)i * freq);
        }
        for (i = 1; i < m / 4; ++i) {
            tab[m / 2 - i] = tab[i];
        }
    }

    private static int splitRadixPermutation(int i, int n, boolean inverse) {
        if (n <= 2) {
            return i & 1;
        }
        int m = n >> 1;
        if ((i & m) == 0) {
            return FFT.splitRadixPermutation(i, m, inverse) * 2;
        }
        return FFT.splitRadixPermutation(i, m >>= 1, inverse) * 4 + (inverse == ((i & m) == 0) ? 1 : -1);
    }

    private int fftInit(int nbits, boolean inverse) {
        if (nbits < 2 || nbits > 16) {
            this.revtab = null;
            this.tmpBuf = null;
            return -1;
        }
        this.nbits = nbits;
        this.inverse = inverse;
        int n = 1 << nbits;
        this.revtab = new int[n];
        this.tmpBuf = new float[n * 2];
        FFT.initFfCosTabs(ff_cos_16, 16);
        FFT.initFfCosTabs(ff_cos_32, 32);
        FFT.initFfCosTabs(ff_cos_64, 64);
        FFT.initFfCosTabs(ff_cos_128, 128);
        FFT.initFfCosTabs(ff_cos_256, 256);
        FFT.initFfCosTabs(ff_cos_512, 512);
        for (int i = 0; i < n; ++i) {
            this.revtab[-FFT.splitRadixPermutation((int)i, (int)n, (boolean)inverse) & n - 1] = i;
        }
        return 0;
    }

    public int mdctInit(int nbits, boolean inverse, double scale) {
        int n = 1 << nbits;
        this.mdctBits = nbits;
        this.mdctSize = n;
        int n4 = n >> 2;
        int ret = this.fftInit(this.mdctBits - 2, inverse);
        if (ret < 0) {
            return ret;
        }
        this.tcos = new float[n4];
        this.tsin = new float[n4];
        double theta = 0.125 + (double)(scale < 0.0 ? n4 : 0);
        scale = Math.sqrt(Math.abs(scale));
        for (int i = 0; i < n4; ++i) {
            double alpha = Math.PI * 2 * ((double)i + theta) / (double)n;
            this.tcos[i] = (float)(-Math.cos(alpha) * scale);
            this.tsin[i] = (float)(-Math.sin(alpha) * scale);
        }
        return 0;
    }

    public void imdctCalc(float[] output, int outputOffset, float[] input, int inputOffset) {
        int n = 1 << this.mdctBits;
        int n2 = n >> 1;
        int n4 = n >> 2;
        this.imdctHalf(output, outputOffset + n4, input, inputOffset);
        for (int k = 0; k < n4; ++k) {
            output[outputOffset + k] = -output[outputOffset + n2 - k - 1];
            output[outputOffset + n - k - 1] = output[outputOffset + n2 + k];
        }
    }

    public void imdctHalf(float[] output, int outputOffset, float[] input, int inputOffset) {
        int n = 1 << this.mdctBits;
        int n2 = n >> 1;
        int n4 = n >> 2;
        int n8 = n >> 3;
        int in1 = 0;
        int in2 = n2 - 1;
        for (int k = 0; k < n4; ++k) {
            int j = this.revtab[k];
            FFT.CMUL(output, outputOffset + j * 2, outputOffset + j * 2 + 1, input[inputOffset + in2], input[inputOffset + in1], this.tcos[k], this.tsin[k]);
            in1 += 2;
            in2 -= 2;
        }
        this.fftCalcFloat(output, outputOffset);
        float[] r = new float[4];
        for (int k = 0; k < n8; ++k) {
            FFT.CMUL(r, 0, 3, output[outputOffset + (n8 - k - 1) * 2 + 1], output[outputOffset + (n8 - k - 1) * 2 + 0], this.tsin[n8 - k - 1], this.tcos[n8 - k - 1]);
            FFT.CMUL(r, 2, 1, output[outputOffset + (n8 + k) * 2 + 1], output[outputOffset + (n8 + k) * 2 + 0], this.tsin[n8 + k], this.tcos[n8 + k]);
            output[outputOffset + (n8 - k - 1) * 2 + 0] = r[0];
            output[outputOffset + (n8 - k - 1) * 2 + 1] = r[1];
            output[outputOffset + (n8 + k) * 2 + 0] = r[2];
            output[outputOffset + (n8 + k) * 2 + 1] = r[3];
        }
    }

    private static void CMUL(float[] d, int dre, int dim, float are, float aim, float bre, float bim) {
        d[dre] = are * bre - aim * bim;
        d[dim] = are * bim + aim * bre;
    }

    private void fft4(float[] z, int o) {
        double t3 = z[o + 0] - z[o + 2];
        double t1 = z[o + 0] + z[o + 2];
        double t8 = z[o + 6] - z[o + 4];
        double t6 = z[o + 6] + z[o + 4];
        z[o + 4] = (float)(t1 - t6);
        z[o + 0] = (float)(t1 + t6);
        double t4 = z[o + 1] - z[o + 3];
        double t2 = z[o + 1] + z[o + 3];
        double t7 = z[o + 5] - z[o + 7];
        double t5 = z[o + 5] + z[o + 7];
        z[o + 7] = (float)(t4 - t8);
        z[o + 3] = (float)(t4 + t8);
        z[o + 6] = (float)(t3 - t7);
        z[o + 2] = (float)(t3 + t7);
        z[o + 5] = (float)(t2 - t5);
        z[o + 1] = (float)(t2 + t5);
    }

    private void fft8(float[] z, int o) {
        this.fft4(z, o);
        double t1 = z[o + 8] + z[o + 10];
        z[o + 10] = z[o + 8] - z[o + 10];
        double t2 = z[o + 9] + z[o + 11];
        z[o + 11] = z[o + 9] - z[o + 11];
        double t5 = z[o + 12] + z[o + 14];
        z[o + 14] = z[o + 12] - z[o + 14];
        double t6 = z[o + 13] + z[o + 15];
        z[o + 15] = z[o + 13] - z[o + 15];
        double t3 = t5 - t1;
        z[o + 8] = (float)((double)z[o + 0] - (t5 += t1));
        z[o + 0] = (float)((double)z[o + 0] + t5);
        z[o + 13] = (float)((double)z[o + 5] - t3);
        z[o + 5] = (float)((double)z[o + 5] + t3);
        double t4 = t2 - t6;
        t6 = t2 + t6;
        z[o + 12] = (float)((double)z[o + 4] - t4);
        z[o + 4] = (float)((double)z[o + 4] + t4);
        z[o + 9] = (float)((double)z[o + 1] - t6);
        z[o + 1] = (float)((double)z[o + 1] + t6);
        t1 = z[o + 10] * 0.70710677f + z[o + 11] * 0.70710677f;
        t2 = -z[o + 10] * 0.70710677f + z[o + 11] * 0.70710677f;
        t5 = z[o + 14] * 0.70710677f - z[o + 15] * 0.70710677f;
        t6 = z[o + 14] * 0.70710677f + z[o + 15] * 0.70710677f;
        t3 = t5 - t1;
        z[o + 10] = (float)((double)z[o + 2] - (t5 += t1));
        z[o + 2] = (float)((double)z[o + 2] + t5);
        z[o + 15] = (float)((double)z[o + 7] - t3);
        z[o + 7] = (float)((double)z[o + 7] + t3);
        t4 = t2 - t6;
        t6 = t2 + t6;
        z[o + 14] = (float)((double)z[o + 6] - t4);
        z[o + 6] = (float)((double)z[o + 6] + t4);
        z[o + 11] = (float)((double)z[o + 3] - t6);
        z[o + 3] = (float)((double)z[o + 3] + t6);
    }

    private void pass(float[] z, int o, float[] cos, int n) {
        int o0 = o;
        int o1 = o + 2 * n * 2;
        int o2 = o + 4 * n * 2;
        int o3 = o + 6 * n * 2;
        int wre = 0;
        int wim = 2 * n;
        --n;
        double t1 = z[o2 + 0];
        double t2 = z[o2 + 1];
        double t5 = z[o3 + 0];
        double t6 = z[o3 + 1];
        double t3 = t5 - t1;
        z[o2 + 0] = (float)((double)z[o0 + 0] - (t5 += t1));
        z[o0 + 0] = (float)((double)z[o0 + 0] + t5);
        z[o3 + 1] = (float)((double)z[o1 + 1] - t3);
        z[o1 + 1] = (float)((double)z[o1 + 1] + t3);
        double t4 = t2 - t6;
        t6 = t2 + t6;
        z[o3 + 0] = (float)((double)z[o1 + 0] - t4);
        z[o1 + 0] = (float)((double)z[o1 + 0] + t4);
        z[o2 + 1] = (float)((double)z[o0 + 1] - t6);
        z[o0 + 1] = (float)((double)z[o0 + 1] + t6);
        t1 = z[o2 + 2] * cos[wre + 1] + z[o2 + 3] * cos[wim - 1];
        t2 = -z[o2 + 2] * cos[wim - 1] + z[o2 + 3] * cos[wre + 1];
        t5 = z[o3 + 2] * cos[wre + 1] - z[o3 + 3] * cos[wim - 1];
        t6 = z[o3 + 2] * cos[wim - 1] + z[o3 + 3] * cos[wre + 1];
        t3 = t5 - t1;
        z[o2 + 2] = (float)((double)z[o0 + 2] - (t5 += t1));
        z[o0 + 2] = (float)((double)z[o0 + 2] + t5);
        z[o3 + 3] = (float)((double)z[o1 + 3] - t3);
        z[o1 + 3] = (float)((double)z[o1 + 3] + t3);
        t4 = t2 - t6;
        t6 = t2 + t6;
        z[o3 + 2] = (float)((double)z[o1 + 2] - t4);
        z[o1 + 2] = (float)((double)z[o1 + 2] + t4);
        z[o2 + 3] = (float)((double)z[o0 + 3] - t6);
        z[o0 + 3] = (float)((double)z[o0 + 3] + t6);
        do {
            o0 += 4;
            o1 += 4;
            t1 = z[(o2 += 4) + 0] * cos[wre += 2] + z[o2 + 1] * cos[wim -= 2];
            t2 = -z[o2 + 0] * cos[wim] + z[o2 + 1] * cos[wre];
            t5 = z[(o3 += 4) + 0] * cos[wre] - z[o3 + 1] * cos[wim];
            t6 = z[o3 + 0] * cos[wim] + z[o3 + 1] * cos[wre];
            t3 = t5 - t1;
            z[o2 + 0] = (float)((double)z[o0 + 0] - (t5 += t1));
            z[o0 + 0] = (float)((double)z[o0 + 0] + t5);
            z[o3 + 1] = (float)((double)z[o1 + 1] - t3);
            z[o1 + 1] = (float)((double)z[o1 + 1] + t3);
            t4 = t2 - t6;
            t6 = t2 + t6;
            z[o3 + 0] = (float)((double)z[o1 + 0] - t4);
            z[o1 + 0] = (float)((double)z[o1 + 0] + t4);
            z[o2 + 1] = (float)((double)z[o0 + 1] - t6);
            z[o0 + 1] = (float)((double)z[o0 + 1] + t6);
            t1 = z[o2 + 2] * cos[wre + 1] + z[o2 + 3] * cos[wim - 1];
            t2 = -z[o2 + 2] * cos[wim - 1] + z[o2 + 3] * cos[wre + 1];
            t5 = z[o3 + 2] * cos[wre + 1] - z[o3 + 3] * cos[wim - 1];
            t6 = z[o3 + 2] * cos[wim - 1] + z[o3 + 3] * cos[wre + 1];
            t3 = t5 - t1;
            z[o2 + 2] = (float)((double)z[o0 + 2] - (t5 += t1));
            z[o0 + 2] = (float)((double)z[o0 + 2] + t5);
            z[o3 + 3] = (float)((double)z[o1 + 3] - t3);
            z[o1 + 3] = (float)((double)z[o1 + 3] + t3);
            t4 = t2 - t6;
            t6 = t2 + t6;
            z[o3 + 2] = (float)((double)z[o1 + 2] - t4);
            z[o1 + 2] = (float)((double)z[o1 + 2] + t4);
            z[o2 + 3] = (float)((double)z[o0 + 3] - t6);
            z[o0 + 3] = (float)((double)z[o0 + 3] + t6);
        } while (--n != 0);
    }

    private void fft16(float[] z, int o) {
        this.fft8(z, o);
        this.fft4(z, o + 16);
        this.fft4(z, o + 24);
        this.pass(z, o, ff_cos_16, 2);
    }

    private void fft32(float[] z, int o) {
        this.fft16(z, o);
        this.fft8(z, o + 32);
        this.fft8(z, o + 48);
        this.pass(z, o, ff_cos_32, 4);
    }

    private void fft64(float[] z, int o) {
        this.fft32(z, o);
        this.fft16(z, o + 64);
        this.fft16(z, o + 96);
        this.pass(z, o, ff_cos_64, 8);
    }

    private void fft128(float[] z, int o) {
        this.fft64(z, o);
        this.fft32(z, o + 128);
        this.fft32(z, o + 192);
        this.pass(z, o, ff_cos_128, 16);
    }

    private void fft256(float[] z, int o) {
        this.fft128(z, o);
        this.fft64(z, o + 256);
        this.fft64(z, o + 384);
        this.pass(z, o, ff_cos_256, 32);
    }

    private void fft512(float[] z, int o) {
        this.fft256(z, o);
        this.fft128(z, o + 512);
        this.fft128(z, o + 768);
        this.pass(z, o, ff_cos_512, 64);
    }

    public void fftCalcFloat(float[] z, int o) {
        switch (this.nbits) {
            case 2: {
                this.fft4(z, 0);
                break;
            }
            case 3: {
                this.fft8(z, o);
                break;
            }
            case 4: {
                this.fft16(z, 0);
                break;
            }
            case 5: {
                this.fft32(z, 0);
                break;
            }
            case 6: {
                this.fft64(z, o);
                break;
            }
            case 7: {
                this.fft128(z, o);
                break;
            }
            case 8: {
                this.fft256(z, 0);
                break;
            }
            case 9: {
                this.fft512(z, 0);
                break;
            }
            default: {
                log.error((Object)String.format("FFT nbits=%d not implemented", this.nbits));
            }
        }
    }

    public void mdctCalc(float[] output, int outputOffset, float[] input, int inputOffset) {
        int n = 1 << this.mdctBits;
        int n2 = n >> 1;
        int n4 = n >> 2;
        int n8 = n >> 3;
        int n3 = 3 * n4;
        for (int i = 0; i < n8; ++i) {
            float re = -input[inputOffset + 2 * i + n3] - input[inputOffset + n3 - 1 - 2 * i];
            float im = -input[inputOffset + n4 + 2 * i] + input[inputOffset + n4 - 1 - 2 * i];
            int j = this.revtab[i];
            FFT.CMUL(output, outputOffset + 2 * j + 0, outputOffset + 2 * j + 1, re, im, -this.tcos[i], this.tsin[i]);
            re = input[inputOffset + 2 * i] - input[inputOffset + n2 - 1 - 2 * i];
            im = -input[inputOffset + n2 + 2 * i] - input[inputOffset + n - 1 - 2 * i];
            j = this.revtab[n8 + i];
            FFT.CMUL(output, outputOffset + 2 * j + 0, outputOffset + 2 * j + 1, re, im, -this.tcos[n8 + i], this.tsin[n8 + i]);
        }
        this.fftCalcFloat(output, outputOffset);
        float[] r = new float[4];
        for (int i = 0; i < n8; ++i) {
            FFT.CMUL(r, 3, 0, output[outputOffset + (n8 - i - 1) * 2 + 0], output[outputOffset + (n8 - i - 1) * 2 + 1], -this.tsin[n8 - i - 1], -this.tcos[n8 - i - 1]);
            FFT.CMUL(r, 1, 2, output[outputOffset + (n8 + i) * 2 + 0], output[outputOffset + (n8 + i) * 2 + 1], -this.tsin[n8 + i], -this.tcos[n8 + i]);
            output[outputOffset + (n8 - i - 1) * 2 + 0] = r[0];
            output[outputOffset + (n8 - i - 1) * 2 + 1] = r[1];
            output[outputOffset + (n8 + i) * 2 + 0] = r[2];
            output[outputOffset + (n8 + i) * 2 + 1] = r[3];
        }
    }
}

